#ifndef __CDropEvent__
#define __CDropEvent__

#include <Basics/CString.hpp>
#include <Collections/CollectionTypedef.h>
#include <MathTools/CPoint.hpp>

//	===========================================================================

using Exponent::Basics::CString;
using Exponent::Collections::TStringCountedPointerArray;
using Exponent::MathTools::CPoint;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Events
		{
			/**
			 * @class CDropEvent CDropEvent.hpp
			 * @brief Allows for responding to drop file actions
			 *
			 * @date 19/03/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CDropEvent.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CDropEvent : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				// Construction
				CDropEvent(const CPoint &position);

				// Destruction
				virtual ~CDropEvent();

	//	===========================================================================

				// Assignment operator
				CDropEvent &operator = (const CDropEvent &event);

				// Set the position of the drop
				void setDropFilePosition(const CPoint &position);

	//	===========================================================================

				// Get the string array
				TStringCountedPointerArray *getDroppedFileNames() const;

				// Get the position of the drop
				const CPoint &getDropFilePosition() const;

	//	===========================================================================

			protected:

				TStringCountedPointerArray *m_droppedFiles;			/**< The names of the files tht have been dropped */
				CPoint m_position;									/**< The position that they were dropped at */
			};
		}
	}
}
#endif	// End of CDropEvent.hpp